implementation module controllayout


//	Control layout calculations


import ioTypes

//!
//!		Types For this module]
//!

:: NewItemPos :== ( ItemLoc, ItemOffset )

:: ItemLoc
	=  NLeftTop
	|  NRightTop
	|  NLeftBottom
	|  NRightBottom
	|  NLeft
	|  NCenter
	|  NRight
	|  NLeftOf  Id
	|  NRightTo Id
	|  NAbove   Id
	|  NBelow   Id

:: ItemOffset :== (Int, Int)


//	Calculate the precise position (in pixels) of each ItPos element.
//                                                    (0,0)
calcItemPositions :: !(!Int,!Int) !(!Int,!Int) !Size !Size ![ItPos] -> (!Size,![ItPos])
calcItemPositions margins=:(wMargin,hMargin) itemSpaces reqSize minSize itPoss
	=	((w+2*wMargin,h+2*hMargin),itPoss2)
where
	(_,itPoss1)	= StateMap2 (calcItemPosition itemSpaces) itPoss (0,[])
	size		= calcAreaSize itPoss1 reqSize minSize
	(w, h)		= size
	itPoss2		= StateMap2 (renterCornerItem margins size) itPoss1 []


/*	Calculate the positions of line oriented items and the space they occupy. 
	Place relatively placed items in the dependency list of the item referred to.
	Relatively placed items with unknown reference are transformed to (Nleft,(0,0)) items.
	
	(Note:	Renter = Right or Center,
			Corner = LeftTop, RightTop, LeftBottom or RightBottom) */

calcItemPosition :: !(!Int,!Int) !ItPos !(!Int,![ItPos]) -> (!Int,![ItPos])
calcItemPosition itemSpaces item1 sDone=:(sizeY,done)
|	isRelative && exists	=	(sizeY1, [item2`:done1])
							with
								calcXorY		= if (IsRelativeX pos1) calcXPosition calcYPosition
								(sizeY1,item2`)	= calcXorY itemSpaces sizeY id2 item1 item2
|	isRelative				=	calcItemPosition itemSpaces {item1 & ipPos=(NLeft,(0,0))} sDone
|	IsCorner pos1			=	(sizeY,  [item1:done])
							=	(sizeY+yOffset1+h, [ipShift (0,sizeY+yOffset1) item1:done])
							with
								(_,_, _,h)		= item1.ipRect
								(_,	offset)		= pos1
								(_, yOffset)	= offset
								(_,	ySpace)		= itemSpaces
								yOffset1		= if (sizeY==0) yOffset (ySpace+yOffset)
where
	pos1					= item1.ipPos
	(isRelative, id2)		= IsRelative pos1
	(exists,item2,done1)	= ipRemoveItPos id2 done
	
	calcXPosition :: !(!Int,!Int) !Int !Id !ItPos !ItPos -> (!Int,!ItPos)
	calcXPosition itemSpaces sizeY id2 item1 item2
		=	(	if (IsCorner pos2) sizeY (max (t+tShift+h1) sizeY)
			,	shift {item2 & ipDepends = [newDepend:depends2]}
			)
	where
		(xSpace,_)			= itemSpaces
		(xOffset, yOffset)	= offset
		xOffset1			= max 0 (xSpace+xOffset)
		l					= if (IsLeftOf pos1) (l2-w1-xOffset1) (l2+w2+xOffset1)
		t					= t2+yOffset
		lShift				= shiftToZero l
		tShift				= shiftToZero t
		shiftVector			= (lShift,tShift)
		shift				= if (lShift>0 || tShift>0) (ipShift shiftVector) id
		(_,offset)			= pos1
		id1					= item1.ipId
		ctrlid1             = item1.ipCtrlId
		ipoffset1			= item1.ipOffset
		pos1				= item1.ipPos
		pos2				= item2.ipPos
		rect1				= item1.ipRect
		(l1,t1, w1,h1)		= rect1
		(l2,t2, w2,_)		= ipGetItemRect id2 item2
		newDepend			= cpShift (l-l1,t-t1) {cpId=id1,cpCtrlId=ctrlid1,cpRect=rect1,cpOffset=ipoffset1}
		depends2			= item2.ipDepends
	
	calcYPosition :: !(!Int,!Int) !Int !Id !ItPos !ItPos -> (!Int,!ItPos)
	calcYPosition itemSpaces sizeY id2 item1 item2
		=	(	if (IsCorner pos2) sizeY (max (t+tShift+h1) sizeY)
			,	shift {item2 & ipDepends = [newDepend:depends2]}
			)
	where
		(_,ySpace)			= itemSpaces
		(xOffset, yOffset)	= offset
		yOffset1			= max 0 (ySpace+yOffset)
		l					= l2+xOffset
		t					= if (IsBelow pos1) (t2+h2+yOffset1) (t2-h1-yOffset1)
		lShift				= shiftToZero l
		tShift				= shiftToZero t
		shiftVector			= (lShift,tShift)
		shift				= if (lShift>0 || tShift>0) (ipShift shiftVector) id
		(_, offset)			= pos1
		id1					= item1.ipId
		ctrlid1             = item1.ipCtrlId
		cpoffset1			= item1.ipOffset
		pos1				= item1.ipPos
		pos2				= item2.ipPos
		(l1,t1, _,h1)		= rect1
		rect1				= item1.ipRect
		(l2,t2, _,h2)		= ipGetItemRect id2 item2
		newDepend			= cpShift (l-l1,t-t1) {cpId=id1,cpCtrlId=ctrlid1,cpRect=rect1,cpOffset=cpoffset1}
		depends2			= item2.ipDepends
	
	shiftToZero :: !Int -> Int
	shiftToZero x
	|	x<0	= 0-x
			= 0

/*	In case no requested size is given (requested size==(0,0)), calculate the actual 
	width and height of the overall area. The overall area is the smallest enclosing 
	rectangle of the line oriented items, provided it fits the corner oriented items.
	In case of a requested size, yield this size.	*/

calcAreaSize :: ![ItPos] !Size !Size -> Size
calcAreaSize ips (0,0) (minW,minH)
	=	(max pgW minW, max pgH minH)
where
	(pgW,pgH) = StateMap2 calcItemAreaSize ips (0,0)
	
	calcItemAreaSize :: !ItPos !Size -> Size
	calcItemAreaSize item size
					= extendAreaSize pos sizeItem size
	where
		pos			= item.ipPos
		depends		= item.ipDepends
		(l,t, w,h)	= item.ipRect
		sizeItem	= cpMaxXY (l+w,t+h) depends
		
		extendAreaSize :: !NewItemPos !Size !Size -> Size
		extendAreaSize (NLeftTop,	(dx,dy)) (itemR,itemB) (sizeX,sizeY) = (max sizeX (itemR+dx),max sizeY (itemB+dy))
		extendAreaSize (NRightTop,	(dx,dy)) (itemR,itemB) (sizeX,sizeY) = (max sizeX (itemR-dx),max sizeY (itemB+dy))
		extendAreaSize (NLeftBottom,	(dx,dy)) (itemR,itemB) (sizeX,sizeY) = (max sizeX (itemR+dx),max sizeY (itemB-dy))
		extendAreaSize (NRightBottom,(dx,dy)) (itemR,itemB) (sizeX,sizeY) = (max sizeX (itemR-dx),max sizeY (itemB-dy))
		extendAreaSize (_,			(dx,dy)) (itemR,itemB) (sizeX,sizeY) = (max sizeX (itemR+dx),max sizeY itemB)
calcAreaSize _ (reqW,reqH) (minW,minH)
	=	(max minW reqW,max minH reqH)


/*	Position Renter/Corner items and adjust all elements to margins. */

renterCornerItem :: !(!Int,!Int) !Size !ItPos ![ItPos] -> [ItPos]
renterCornerItem margins sizeArea=:(width,height) item done
|	IsRenter pos || IsCorner pos
	=	[ipShift shift item:done]
	with
		depends				= item.ipDepends
		(l,t, w,h)			= item.ipRect
		(wMargin,hMargin)	= margins
		sizeItem			= cpMaxXY (l+w,t+h) depends
		(wItem,_)			= sizeItem
		widthLeft			= width-wItem
		(dX,dY)				= if (IsCorner pos)
								 (cornerShift pos sizeItem sizeArea)
								 (lineShift   pos widthLeft,0)
		shift				= (dX+wMargin,dY+hMargin)
		
		lineShift :: !NewItemPos !Int -> Int
		lineShift (NCenter,(x,_)) space = space/2+x
		lineShift (_,	   (x,_)) space = space	+x
		
		cornerShift :: !NewItemPos !Size !Size -> ItemOffset
		cornerShift (NLeftTop,	 (x,y)) _			  _		= (x,			y)
		cornerShift (NRightTop,	 (x,y)) (wItem,_)	  (w,_)	= (w-wItem+x,	y)
		cornerShift (NLeftBottom, (x,y)) (_,hItem)	  (_,h)	= (x,			h-hItem+y)
		cornerShift (NRightBottom,(x,y)) (wItem,hItem) (w,h)	= (w-wItem+x,	h-hItem+y)
	=	[ipShift margins item:done]
where
	pos	= item.ipPos


//	ItPos operations.

//! Changed ItemPos field to NewItemPos
::	ItPos
	=	{	ipId		:: Id					
	    ,   ipCtrlId    :: Id                   // The ControlId
		,	ipPos		:: NewItemPos			// The given NewItemPos
		,	ipRect		:: Rect					// Position (x,y) and size (w,h) of item (x,y,w,h)
		,	ipDepends	:: [RCPos]				// Dependent items (this item is Renter/Corner item)
		,	ipOffset	:: ItemOffset			// The vector by which compound elements should be moved
		}

//! Changed 'sysId 0' to '0'
dummyItPos
	:==	{	ipId		= 0             
	    ,   ipCtrlId    = 0
		,	ipPos		= (NLeft,(0,0))
		,	ipRect		= (0,0,0,0)
		,	ipDepends	= []
		,	ipOffset	= (0,0)
		}



newItPos :: !Int !Id !NewItemPos !Size -> ItPos
newItPos n id pos (w,h) = {ipId=n, ipCtrlId = id,ipPos=pos,ipRect=(0,0,w,h),ipDepends=[],ipOffset=(0,0)}


ipShift :: !ItemOffset !ItPos -> ItPos
ipShift offset itPos=:{ipRect,ipDepends,ipOffset}
	=	{ itPos &	ipRect		= rectShift offset ipRect
				,	ipDepends	= map (cpShift offset) ipDepends
				,	ipOffset	= vectorShift offset ipOffset
		}
ipGetItemRect :: !Id !ItPos -> Rect
ipGetItemRect id itPos=:{ipId}
|	id==ipId	= itPos.ipRect
				= cp.cpRect
where
	(_,cp) = Select (cpEqId id) dummyCPos itPos.ipDepends


ipRemoveItPos :: !Id ![ItPos] -> (!Bool,!ItPos,![ItPos])
ipRemoveItPos id [itPos:itPoss]
|	id==itPos.ipId					= (True,	itPos, itPoss)
|	cpContainsId id itPos.ipDepends	= (True,	itPos, itPoss)
									= (exists,	itPos1,[itPos:itPoss1])
									with
										(exists,itPos1,itPoss1)	= ipRemoveItPos id itPoss
ipRemoveItPos _ itPoss = (False,dummyItPos,itPoss)



//	RCPos operations.
::	RCPos
	=	{	cpId		:: Id					
        ,   cpCtrlId    :: Id					// The ControlId
		,	cpRect		:: Rect					// Position (x,y) and size (w,h) of item (x,y,w,h)
		,	cpOffset	:: ItemOffset			// The vector by which compound elements should be moved
		}

//! Changed 'sysId 0' to '0'
dummyCPos
	:==	{	cpId		= 0
		,   cpCtrlId    = 0
		,	cpRect		= (0,0,0,0)
		,	cpOffset	= (0,0)
		}


cpEqId :: !Id !RCPos -> Bool
cpEqId id {cpId} = id==cpId


cpShift :: !ItemOffset !RCPos -> RCPos
cpShift offset cp=:{cpRect,cpOffset}
	= {	cp	&	cpRect		= rectShift offset cpRect
			,	cpOffset	= vectorShift offset cpOffset
	  }

rectShift :: !ItemOffset !Rect -> Rect
rectShift (dX,dY) (l,t, w,h) = (l+dX,t+dY, w,h)

vectorShift :: !ItemOffset !ItemOffset -> ItemOffset
vectorShift (dX,dY) (x,y) = (x+dX,y+dY)

cpMaxXY :: !(!Int,!Int) ![RCPos] -> (!Int,!Int)
cpMaxXY (maxX,maxY) [cp:cps]
	= 	cpMaxXY (max maxX (l+w), max maxY (t+h)) cps
where
	(l,t, w,h) = cp.cpRect
cpMaxXY max _ = max


cpContainsId :: !Id ![RCPos] -> Bool
cpContainsId id [cp:cps]
|	id==cp.cpId		= True
					= cpContainsId id cps
cpContainsId _ _	= False


//	NewItemPos predicates.

IsRelative :: !NewItemPos -> (!Bool,!Id)
IsRelative (NLeftOf	id,_)	= (True,id)
IsRelative (NRightTo	id,_)	= (True,id)
IsRelative (NAbove	id,_)	= (True,id)
IsRelative (NBelow	id,_)	= (True,id)
IsRelative _				= (False,0)

IsRelativeX :: !NewItemPos		-> Bool
IsRelativeX (NLeftOf	 _,_)	= True
IsRelativeX (NRightTo _,_)	= True
IsRelativeX _				= False

IsRenter :: !NewItemPos		-> Bool
IsRenter (NCenter,_)			= True
IsRenter (NRight, _)			= True
IsRenter _					= False

IsCorner :: !NewItemPos		-> Bool
IsCorner (NLeftTop,    _)	= True
IsCorner (NRightTop,	  _)	= True
IsCorner (NLeftBottom, _)	= True
IsCorner (NRightBottom,_)	= True
IsCorner _					= False

IsLeftOf :: !NewItemPos		-> Bool
IsLeftOf (NLeftOf _,_)		= True
IsLeftOf _					= False

IsBelow  :: !NewItemPos		-> Bool
IsBelow  (NBelow _,_)		= True
IsBelow  _					= False
